/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.simulation.OfflineInterpreter;
import DE.siemens.ad.pdraw.util.OutputDisplay;
import java.awt.Component;
import javax.swing.JTextField;

public class AnalogOutputDisplay
extends OutputDisplay {
    private JTextField fAnalogField = new JTextField("0");

    public AnalogOutputDisplay(OutputBlock block) {
        super(block);
        this.fAnalogField.setEditable(false);
        this.fAnalogField.setColumns(6);
        this.add((Component)this.fAnalogField, "Center");
    }

    public void reset() {
        if (!this.fBlock.getWiringDiagram().getHardware().supports("0BA5AnalogCalculation") || this.fBlock instanceof AnalogMarkerBlock) {
            this.fAnalogField.setText("0");
            return;
        }
        if (this.fBlock.getWiringDiagram().getDrawingProperties().getAnalogOutputLastValueStatus()) {
            return;
        }
        double fixedValue = this.fBlock.getNumber() == 1 ? this.fBlock.getWiringDiagram().getDrawingProperties().getAnalogOutputFixedValue1() : this.fBlock.getWiringDiagram().getDrawingProperties().getAnalogOutputFixedValue2();
        this.fAnalogField.setText(Double.toString(fixedValue));
    }

    public void setState() {
        double analogValue = 0.0;
        analogValue = this.fBlock.getAnalogValue();
        if (!Double.toString(analogValue).equals(this.fAnalogField.getText())) {
            this.fAnalogField.setText(Double.toString(analogValue));
        }
    }

    public void init() {
        this.fAnalogField.setText(Double.toString(this.fBlock.getAnalogValue()));
    }

    public void stateChanged(StateMachine stateMachine, StateMachine.State newState) {
        if (newState instanceof OfflineInterpreter.RunningNetOff || newState instanceof OfflineInterpreter.SuspendedNetOff || newState instanceof OfflineInterpreter.CycleSteppingNetOff || newState instanceof OfflineInterpreter.TimerSteppingNetOff || newState instanceof OfflineInterpreter.StoppedNetOff) {
            this.fAnalogField.setText("0");
        }
    }

    public void finalStateReached(StateMachine stateMachine, StateMachine.State finalState) {
    }
}

